function [F,cvlow,cvup]=Fluctuation(DeltaL,dates,windowSize,hac,alpha);

%INPUT: DeltaL is the sequence of forecast error losses (e.g. squared forecast error of model 1 minus squared forecast %       error of model 2
%       m is the size of the rolling window
%       hac =1 if estimating the variance with HAC (otherwise set it to zero)
%       alpha=significance level (e.g. 0.05 for a 5% -- it can be 0.05 or 0.10)
%OUTPUT:
%Barbara, May 2007 

y1=filter(ones(1,windowSize)/windowSize,1,DeltaL); y=y1(windowSize:end,:); %y is the series of rolling window's centered moving averages
T=length(y); x=ones(T,1); qn=ceil(T^(1/4));  
if hac==1;  addpath C:\brossi\research\library\hac; sigma=olsstddevnw(y,x,qn); 
else;       addpath C:\brossi\research\library\ols; sigma=olsstddevbetahat(y,x);
end; 
F=(y./sigma)*sqrt(windowSize);     
%     window/T  0.05   0.10
cvtable=[0.1, 3.393, 3.170;
         0.2, 3.179, 2.948;
         0.3, 3.012, 2.766;
         0.4, 2.890, 2.626;
         0.5, 2.779, 2.500;
         0.6, 2.634, 2.356;
         0.7, 2.560, 2.252;
         0.8, 2.433, 2.130;
         0.9, 2.248, 1.950];
if alpha==0.05; j=2; elseif alpha==0.10; j=3; end;
mu=(ceil((windowSize/T)*10))/10; i=mu*10; 
cv=cvtable(i,j); 
tforgraph2=filter(ones(1,windowSize)/windowSize,1,dates); tforgraph=tforgraph2(windowSize:end,:);
figure; plot(tforgraph,F,'LineWidth',2); hold on; plot(tforgraph,-cv*ones(T,1),'r--','LineWidth',2); plot(tforgraph,cv*ones(T,1),'r--','LineWidth',2); 
ylabel('Fluctuation test'); xlabel('Time'); 
cvlow=-cv*ones(T,1); cvup=cv*ones(T,1); 



%Example to run the code:
%DeltaLt=randn(100,1)+[zeros(50,1);10*ones(50,1)]; sigma2=1; tds=cumsum(ones(100,1));  
%[F,cvlow,cvup]=Fluctuation(DeltaLt,tds,10,1,0.05);
